<?php
/**
 * The template for displaying all team single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package calfin
 */

get_header();
if ( get_post_meta( get_the_ID(), 'calfin_metabox', true ) ) {
    $calfin_commonMeta = get_post_meta( get_the_ID(), 'calfin_metabox', true );
} else {
    $calfin_commonMeta = array();
}
$calfin_team_title = calfin_options( 'calfin_team_title' );
$calfin_breadcrumb_select_html = calfin_options( 'calfin_breadcrumb_select_html', 'h2' );
$calfin_team_banner_enable = calfin_options( 'calfin_team_banner_enable' );
if ( array_key_exists( 'calfin_layout_meta', $calfin_commonMeta ) && !empty( $calfin_commonMeta['calfin_layout_meta'] ) ) {
    $calfin_team_Layout = $calfin_commonMeta['calfin_layout_meta'];
} else {
    $calfin_team_Layout = 'full-width';
}
if ( is_array( $calfin_commonMeta ) && array_key_exists( 'calfin_sidebar_meta', $calfin_commonMeta ) ) {
    $calfin_selectedSidebar = $calfin_commonMeta['calfin_sidebar_meta'];
} else {
    $calfin_selectedSidebar = 'sidebar';
}

if ( $calfin_team_Layout == 'left-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) || $calfin_team_Layout == 'right-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) ) {
    $calfin_teamColumnClass = 'col-12 col-sm-12 col-md-12 col-lg-7 col-xl-8';
} else {
    $calfin_teamColumnClass = 'col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12';
}

if ( $calfin_team_banner_enable == false ) {
    $calfin_team_post_Banner = false;
} elseif ( array_key_exists( 'calfin_meta_enable_banner', $calfin_commonMeta ) ) {
    $calfin_team_post_Banner = $calfin_commonMeta['calfin_meta_enable_banner'];
} else {
    $calfin_team_post_Banner = true;
}
?>
	<?php if ( $calfin_team_post_Banner == true ): ?>
	<div class="breadcroumb-area">
		<div class="container">
			<div class="breadcroumn-contnt">
				<<?php echo esc_attr( $calfin_breadcrumb_select_html ); ?> class="brea-title"><?php if ( !empty( $calfin_team_title ) ) {
					echo esc_html( $calfin_team_title );
				} else {
					echo esc_html( 'Team Details', 'calfin' );
				}?></<?php echo esc_attr( $calfin_breadcrumb_select_html ); ?>>
				<div class="bre-sub">
					<?php if ( function_exists( 'bcn_display' ) ) {
						bcn_display();
					}?>
				</div>
			</div>
		</div>
	</div>
	<?php endif;?>
	<main id="primary" class="site-main content-area">
		<div class="container">
			<div class="page-layout <?php echo esc_attr( $calfin_team_Layout ); ?>">
				<div class="row">
					<?php
						if ( $calfin_team_Layout == 'left-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) ) {
							get_sidebar();
						}
					?>
					<div class="<?php echo esc_attr( $calfin_teamColumnClass ); ?>">
						<div class="all-posts-wrapper">
						<?php
							while ( have_posts() ):
								the_post();

								the_content();
							endwhile; // End of the loop.
							?>
						</div>
					</div>
					<?php
						if ( $calfin_team_Layout == 'right-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) ) {
							get_sidebar();
						}?>
				</div>
			</div>
		</div>
	</main><!-- #main -->
<?php
get_footer();