<?php 
$calfin_single_authors_author = calfin_options('calfin_single_authors_author', true);
$calfin_single_authors_date = calfin_options('calfin_single_authors_date', true);
$calfin_single_authors_cat = calfin_options('calfin_single_authors_cat', true);
$calfin_share_blog = calfin_options('calfin_share_blog', false);
if( has_post_thumbnail() or has_post_format( 'video' ,get_the_ID()) or has_post_format( 'audio' ,get_the_ID())){
    $calfin_thum_class = 'with-thum-img';
}else{
    $calfin_thum_class = 'no-thum-img';
}
$code = 'iframe';
if(get_post_meta( get_the_ID(), 'calfin_postmeta_video', true)) {
	$calfin_postvideo = get_post_meta( get_the_ID(), 'calfin_postmeta_video', true );
}else {
  $calfin_postvideo = array();
}
if(get_post_meta( get_the_ID(), 'calfin_postmeta_audio', true)) {
	$calfin_postaudio = get_post_meta( get_the_ID(), 'calfin_postmeta_audio', true );
}else {
  $calfin_postaudio = array();
}
if(get_post_meta( get_the_ID(), 'calfin_postmeta_gallery', true)) {
	$calfin_postgallery = get_post_meta( get_the_ID(), 'calfin_postmeta_gallery', true );
    $calfin_postgallerys = $calfin_postgallery['calfin_post_gallery']; // for eg. 15,50,70,125
    $calfin_gallery_ids = explode( ',', $calfin_postgallerys );
}else {
  $calfin_postgallery = array();
}
?>
<div class="col-lg-6 col-md-12 grid-post-item single-post-item">
    <div id="post-<?php the_ID(); ?>" <?php post_class('post-single'); ?>>
        <?php 
        if(has_post_format( 'video' ,get_the_ID()) && has_post_thumbnail() ){
            ?>
            <div class="post-img">
                <?php the_post_thumbnail('calfin-blog-full', array('class' => 'img-responsive')); ?>
                
                <a href="<?php echo esc_url($calfin_postvideo['calfin_post_video']); ?>" class="post-video video-popup"><i class="fas fa-play"></i></a>
            </div>
            <?php
        }elseif(has_post_format( 'video' , get_the_ID() ) && !empty($calfin_postvideo['calfin_post_video'])){
            ?>
            <div class="vendor">
                <<?php echo esc_attr($code); ?> width="100%" height="500" src="<?php echo esc_url($calfin_postvideo['calfin_post_video']); ?>"></<?php echo esc_attr($code); ?>>
            </div>
            <?php 
        }elseif(has_post_format( 'audio' , get_the_ID() ) && !empty($calfin_postaudio['calfin_post_audio'])){
            ?>
            <div class="vendor">
                <<?php echo esc_attr($code); ?> width="100%" height="400" src="<?php echo esc_url($calfin_postaudio['calfin_post_audio']); ?>"></<?php echo esc_attr($code); ?>>
            </div>
            <?php 
        }elseif(has_post_format( 'gallery' , get_the_ID() ) && !empty($calfin_gallery_ids)){
            ?>
                <div class="post-gallerys">
                <?php 
                foreach( $calfin_gallery_ids as $gallery_id ){
                    echo wp_get_attachment_image( $gallery_id, 'calfin-blog-medium' );
                }
                ?>
                </div>
            <?php 
        }elseif(has_post_thumbnail()){
            ?>
            <div class="post-img">
                <?php the_post_thumbnail('calfin-blog-medium'); ?>
        </div>
            <?php 
        }
        ?>
       <div class="post-contents <?php echo esc_attr($calfin_thum_class); ?>">
            <div class="post-meta-box d-flex">
                <div class="post-meta-item flex-grow-1">
                    <ul>
                        <li><i class="fas fa-user-alt"></i><?php calfin_posted_by(); ?></li>
                    </ul>
                </div>
                <?php if($calfin_share_blog == true ) : ?>
                <div class="post-share">
                    <label><?php esc_html_e('Share Now','calfin'); ?></label>
                    <?php if(function_exists('calfin_post_share')){
                        calfin_post_share();
                    } ?>
                </div>
                <?php endif; ?>
            </div>
            <div class="post-title">
                <?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
            </div>
            <div class="post-content">
            <p><?php echo wp_trim_words( get_the_content(), 40 ); ?></p>
            </div>
            <div class="post-button d-flex">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="theme-btns"><?php esc_html_e('Read More','calfin'); ?></a>
            </div>
       </div>
    </div>
</div>