<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package calfin
 */
$calfin_single_post_author = calfin_options('calfin_single_post_author', true);
$calfin_single_post_date = calfin_options('calfin_single_post_date', true);
$calfin_single_post_cmnt = calfin_options('calfin_single_post_cmnt', true);
$calfin_single_post_cat = calfin_options('calfin_single_post_cat', true);
$calfin_single_post_tag = calfin_options('calfin_single_post_tag', true);
$calfin_post_share = calfin_options('calfin_post_share', false);
$calfin_post_top_share = calfin_options('calfin_post_top_share', false);
if( has_post_thumbnail() or has_post_format( 'video' ,get_the_ID()) or has_post_format( 'audio' ,get_the_ID())){
    $calfin_thum_class = 'with-thum-img';
}else{
    $calfin_thum_class = 'no-thum-img';
}
$code = 'iframe';
if(get_post_meta( get_the_ID(), 'calfin_postmeta_video', true)) {
	$calfin_postvideo = get_post_meta( get_the_ID(), 'calfin_postmeta_video', true );
}else {
  $calfin_postvideo = array();
}
if(get_post_meta( get_the_ID(), 'calfin_postmeta_audio', true)) {
	$calfin_postaudio = get_post_meta( get_the_ID(), 'calfin_postmeta_audio', true );
}else {
  $calfin_postaudio = array();
}
if(get_post_meta( get_the_ID(), 'calfin_postmeta_gallery', true)) {
	$calfin_postgallery = get_post_meta( get_the_ID(), 'calfin_postmeta_gallery', true );
    $calfin_postgallerys = $calfin_postgallery['calfin_post_gallery']; // for eg. 15,50,70,125
    $calfin_gallery_ids = explode( ',', $calfin_postgallerys );
}else {
  $calfin_postgallery = array();
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('post-details'); ?>>
	<?php 
		if(has_post_format( 'video' ,get_the_ID()) && has_post_thumbnail() ){
			?>
			<div class="post-img">
				<?php the_post_thumbnail('calfin-blog-full', array('class' => 'img-responsive')); ?>
				<a href="<?php echo esc_url($calfin_postvideo['calfin_post_video']); ?>" class="post-video video-popup"><i class="fas fa-play"></i></a>
			</div>
			<?php
		}elseif(has_post_format( 'video' , get_the_ID() ) && !empty($calfin_postvideo['calfin_post_video'])){
			?>
			<div class="vendor post-img">
				<<?php echo esc_attr($code); ?> width="100%" height="500" src="<?php echo esc_url($calfin_postvideo['calfin_post_video']); ?>" frameborder="0" allowfullscreen="false"></<?php echo esc_attr($code); ?>>
			</div>
			<?php 
		}elseif(has_post_format( 'audio' , get_the_ID() ) && !empty($calfin_postaudio['calfin_post_audio'])){
			?>
			<div class="vendor post-img">
				<<?php echo esc_attr($code); ?> width="100%" height="400" src="<?php echo esc_url($calfin_postaudio['calfin_post_audio']); ?>" frameborder="0" allowfullscreen="false"></<?php echo esc_attr($code); ?>>
			</div>
			<?php 
		}elseif(has_post_format( 'gallery' , get_the_ID() ) && !empty($calfin_gallery_ids)){
			?>
				<div class="post-gallerys post-img">
				<?php 
				foreach( $calfin_gallery_ids as $gallery_id ){
					echo wp_get_attachment_image( $gallery_id, 'calfin-blog-full' );
				}
				?>
				</div>
			<?php 
		}elseif(has_post_thumbnail()){
			?>
			<div class="post-img">
				<?php the_post_thumbnail('full', array('class' => 'img-responsive')); ?>
			</div>
			<?php 
		}
	?>
	<div class="<?php echo esc_attr($calfin_thum_class); ?> post-contents entry-content">
		<?php if ( 'post' === get_post_type() ) : ?>
		<div class="post-meta-box d-flex">
			<div class="post-meta-item flex-grow-1">
				<ul>
					<?php if($calfin_single_post_author == true ) : ?>
					<li><i class="fas fa-user-alt"></i><?php calfin_posted_by(); ?></li>
					<?php endif; ?>
					<?php if($calfin_single_post_date == true) : ?>
					<li><i class="fas fa-calendar-alt"></i><?php calfin_posted_on(); ?></li>
					<?php endif; ?>
					<?php if($calfin_single_post_cmnt == true && get_comments_number() != 0) : ?>
                    <li class="comment-number"><i class="fas fa-comment"></i><?php comments_number( 'no responses', 'one Comment', '% Comments' ); ?>.</li>
                    <?php endif; ?>
					<?php if($calfin_single_post_cat == true ) : ?>
					<li class="post-cat"><i class="fas fa-pencil-alt"></i><?php the_category(','); ?></li>
					<?php endif; ?>
				</ul>
			</div>
			<?php if($calfin_post_top_share == true ) : ?>
			<div class="post-share">
				<label><?php esc_html_e('Share Now','calfin'); ?></label>
				<?php if(function_exists('calfin_post_share')){
					calfin_post_share();
				} ?>
			</div>
			<?php endif; ?>
		</div>
		<?php endif; ?>
		<div class="post-content">
		<?php
			/* translators: %s: Name of current post */
			the_content(
				sprintf(
					esc_html__( 'Continue reading %s', 'calfin' ),
					the_title( '<span class="screen-reader-text">', '</span>', false )
				)
			);
			?>
		</div>
		
		<?php if( has_tag() or function_exists( 'calfin_post_share' ) ) : ?>
		<div class="post-tag-social d-flex">
		<?php if($calfin_single_post_tag == true ) : ?>
			<div class="post-tag flex-grow-1">
			<?php if(has_tag()) : ?>
				<label><?php esc_html_e('Tags :','calfin'); ?></label>	<?php calfin_post_tag(); ?>
				<?php endif; ?>
			</div>
			<?php endif; ?>
			<?php if($calfin_post_share == true ) : ?>
			<div class="post-share">
				<label><?php esc_html_e('Share','calfin'); ?></label>
				<?php if(function_exists('calfin_post_share')){
					calfin_post_share();
				} ?>
			</div>
			<?php endif; ?>
		</div>
		<?php endif; ?>
	</div>
</article>
